/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_15; import djbuch.kapitel_06.DemoTools;
import djbuch.kapitel_06.GC;
import lotus.domino.*;

/**
 *
 * Fhrt verschiedene Suchoperationen per search, FTSearch und get[All]Document[s][Entries]ByKey durch<br>
 * und mit die dafr bentigte Zeit und Trefferzahl.<br>
 * Fr jede Suche wird diese mehrfach mit verschiedenen Suchqueries durchgefhrt<br>
 * Das unten gezeigte Beispiel zeigt jeweils nur die Beispielqueries fr den <br>
 * jeweils letzten Durchlauf.<br>
 * Trefferzahl und Laufzeit werden jeweils gemittelt.<br>
 * Durchgefhrt werden folgende Suchen, wobei [..n] andeutet, dass der Suchparameter variiert wird.<br>
 * <br>
 * getDocumentByKey ("Tier 1[..n]")<br>
 * getEntryByKey ("Tier 1[..n]")<br>
 * getAllDocumentsByKey ("Tier 1[..n]", false) // ...,true, falls exactSearch==true<br>
 * getAllEntriesByKey ("Tier 1[..n]", false) // ...,true, falls exactSearch==true<br>
 * view.FTSearch ("FIELD F_titel="Tier 1[..n]*") //Jokersymbol * beachten!<br>
 * view.FTSearch ("FIELD F_titel="Tier 1[..n]?[?[...]]") //Jokersymbol ? beachten! Wird mehrfach variiert.<br>
 * db.FTSearch ("FIELD F_titel="Tier 1[..n]*") //Jokersymbol * beachten!<br>
 * db.search ("@left (F_titel;6)=\"Tier 1[..n]\") //@Formel @left statt Jokersymbol<br>
 * <br>
 **************************************************<br>
 * Beispielausgabe:<br>
 **************************************************<br>
Aufrumen: Lsche 0 Dokumente.<br>
Erzeuge 10100 neue Dokumente.<br>
FT Index aktualisieren.<br>
<br>
SETUP:<br>
Exakte Suche? false<br>
Anzahl der Suchoperationen pro Suche: 9<br>
Anzahl der Dokumente: 10100<br>
Ausfhrungsort der Session: Auf Server CN=Java/O=DJBUCH<br>
FT_MAX_SEARCH_RESULTS = 20000<br>
<br>
Ergebnis:<br>
Einzelnes Dokument ber getDocumentByKey laden:		250ms<br>
	Index hierbei: Tier 1<br>
Einzelnes Dokument ber getEntryByKey laden:		219ms<br>
	Index hierbei: Tier 1<br>
Mehrere Dokumente ber getAllDocumentsByKey laden:	547ms / Treffer = 1111<br>
	Index hierbei: Tier 1<br>
Mehrere Dokumente ber getAllEntriesByKey laden:	1500ms / Treffer = 1111<br>
	Index hierbei: Tier 1<br>
Mehrere Dokumente ber view.FTSearch laden:		2422ms / Treffer = 1111<br>
	Query hierbei: FIELD F_titel="Tier 1*"<br>
Mehrere Dokumente ber view.FTSearch laden:		624ms / Treffer = 1111<br>
	Query hierbei: FIELD F_titel="Tier 1????"<br>
Mehrere Dokumente ber db.FTSearch laden:		2235ms / Treffer = 1111<br>
	Query hierbei: FIELD F_titel="Tier 1*"<br>
Mehrere Dokumente ber db.search laden:			1249ms / Treffer = 1111<br>
	Query hierbei: @left (F_titel;6)="Tier 1"<br>

 * @author Thomas Ekert
 */
public class SearchComparison extends NotesThread{

	private static View view = null;
	private static final String PASSWORD = "geheim";
	private static final String HOST = null; //"www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = null; // "Thomas Ekert/DJBUCH";	//null fr lokale Session
	private static final String DOMINO_SERVER = ""; // "" fr lokale Datenbank
	
	public static void main(String[] args) {
		SearchComparison rtd = new SearchComparison();
		rtd.start();
	}
	public void runNotes() {
		Document doc = null;
		Database db = null;
		Session session = null;
		ViewEntry ve=null;
		DocumentCollection dc = null;
		ViewEntryCollection vec =null;
		try {
			session = NotesFactory.createSession(HOST, USER, PASSWORD);
			db = session.getDatabase(DOMINO_SERVER, "djbuch/djbuch.nsf");
			if (doStartup) { DemoTools.startup (db,NUM_OF_DOCS); }
			view = db.getView("V_lookup_k6");
			view.refresh();
			System.out.println ("\nSETUP:");
			System.out.println ("Exakte Suche? " + exactSearch);
			System.out.println ("Anzahl der Suchoperationen pro Suche: " + SEARCH_COUNT);
			System.out.println ("Anzahl der Dokumente: " + ((int)(NUM_OF_DOCS*1.01)));
			System.out.println ("Ausfhrungsort der Session: " + (HOST==null&&USER==null?"Lokal":"Auf Server " + session.getServerName()));
			int maxResult = getMaxResult (session);
			System.out.println ("FT_MAX_SEARCH_RESULTS = " + session.getEnvironmentString("FT_MAX_SEARCH_RESULTS",true));
			System.out.println ("\nErgebnis:");
			String index="";
			long L = System.currentTimeMillis();
			for (int i=SEARCH_COUNT; i > 0; i--) {				
				index = DemoTools.RANDOM_INDEX?DemoTools.getRandom(SEARCH_WIDTH):""+i;
				doc=view.getDocumentByKey(DemoTools.ANIMAL_A + index,exactSearch);
				GC.recycle(doc);
			}
			System.out.println ("Einzelnes Dokument ber getDocumentByKey laden:\t\t" + (System.currentTimeMillis()-L) + "ms");
			System.out.println ("\tIndex hierbei: " + DemoTools.ANIMAL_A + index);
			L=System.currentTimeMillis();
			for (int i=SEARCH_COUNT; i > 0; i--) {				
				index = DemoTools.RANDOM_INDEX?DemoTools.getRandom(SEARCH_WIDTH):""+i;
				ve=view.getEntryByKey(DemoTools.ANIMAL_A + index,exactSearch);
				GC.recycle(ve);
			}
			System.out.println ("Einzelnes Dokument ber getEntryByKey laden:\t\t" + (System.currentTimeMillis()-L) + "ms");
			System.out.println ("\tIndex hierbei: " + DemoTools.ANIMAL_A + index);
			long size = 0;
			L=System.currentTimeMillis();
			for (int i=SEARCH_COUNT; i > 0; i--) {				
				index = DemoTools.RANDOM_INDEX?DemoTools.getRandom(SEARCH_WIDTH):""+i;
				dc=view.getAllDocumentsByKey(DemoTools.ANIMAL_A + index,exactSearch);
				size+=dc.getCount();
				GC.recycle(dc);
			}
			System.out.println ("Mehrere Dokumente ber getAllDocumentsByKey laden:\t" + (System.currentTimeMillis()-L) + "ms / Treffer = " + (size/SEARCH_COUNT));
			System.out.println ("\tIndex hierbei: " + DemoTools.ANIMAL_A + index);
			size=0;
			L=System.currentTimeMillis();
			for (int i=SEARCH_COUNT; i > 0; i--) {				
				index = DemoTools.RANDOM_INDEX?DemoTools.getRandom(SEARCH_WIDTH):""+i;
				vec=view.getAllEntriesByKey(DemoTools.ANIMAL_A + index,exactSearch);
				size+=vec.getCount();
				GC.recycle(vec);
			}
			System.out.println ("Mehrere Dokumente ber getAllEntriesByKey laden:\t" + (System.currentTimeMillis()-L) + "ms / Treffer = " + (size/SEARCH_COUNT));
			System.out.println ("\tIndex hierbei: " + DemoTools.ANIMAL_A + index);
			size=0;
			L=System.currentTimeMillis();
			long subtract = 0;
			String query="";
			for (int i=SEARCH_COUNT; i > 0; i--) {				
				index = DemoTools.RANDOM_INDEX?DemoTools.getRandom(SEARCH_WIDTH):""+i;
				query="FIELD F_titel=\"" + DemoTools.ANIMAL_A + index + (exactSearch?"":"*") + "\"";
//				query="\"" + DemoTools.ANIMAL_A + index + (exactSearch?"":"*") + "\"";
				view.FTSearch (query);
				long notCount = System.currentTimeMillis();
				vec = view.getAllEntries();
				int c = vec.getCount();
//				System.out.println (query + ": " + c);
				if (c >= maxResult) {
					System.out.println ("[!!!] WARNUNG: Das Trefferlimit von " + maxResult + " Treffern wurde erreicht: " + c);
				}
				size+=c;
				vec = GC.recycle(vec);
				//printViewEntryCollection(view.getAllEntries());
				subtract += System.currentTimeMillis() - notCount;
				view.clear();
			}
			System.out.println ("Mehrere Dokumente ber view.FTSearch laden:\t\t" + (System.currentTimeMillis()-L-subtract) + "ms / Treffer = " + (size/SEARCH_COUNT));
			System.out.println ("\tQuery hierbei: " + query);
			size=0;
			L=System.currentTimeMillis();
			subtract = 0;
			for (int i=SEARCH_COUNT; i > 0; i--) {
				index = DemoTools.RANDOM_INDEX?DemoTools.getRandom(SEARCH_WIDTH):""+i;
				for (int ii = 0; ii <= DemoTools.whichPowerOfTen(NUM_OF_DOCS)-DemoTools.whichPowerOfTen(i); ii++){
					query="FIELD F_titel=\"" + DemoTools.ANIMAL_A + index + (exactSearch?"":DemoTools.repeatChar('?',ii)) + "\"";
					view.FTSearch (query);
					long notCount = System.currentTimeMillis();
					vec = view.getAllEntries();
					int c = vec.getCount();
//					System.out.println (query + ": " + c);
					if (c >= maxResult) {
						System.out.println ("[!!!] WARNUNG: Das Trefferlimit von " + maxResult + " Treffern wurde erreicht: " + c);
					}
					size+=c;
					vec = GC.recycle(vec);
					//printViewEntryCollection(view.getAllEntries());
					view.clear();
					subtract += System.currentTimeMillis() - notCount;
				}
			}
			System.out.println ("Mehrere Dokumente ber view.FTSearch laden:\t\t" + (System.currentTimeMillis()-L-subtract) + "ms / Treffer = " + (size/SEARCH_COUNT));
			System.out.println ("\tQuery hierbei: " + query);
			size=0;
			L=System.currentTimeMillis();
			subtract = 0;
			for (int i=SEARCH_COUNT; i > 0; i--) {				
				index = DemoTools.RANDOM_INDEX?DemoTools.getRandom(SEARCH_WIDTH):""+i;
				query="FIELD F_titel=\"" + DemoTools.ANIMAL_A + index + (exactSearch?"":"*") + "\"";
				dc=db.FTSearch (query);
//				System.out.println(query);
				long notCount = System.currentTimeMillis();
				size+=dc.getCount();
				dc = GC.recycle(dc);
				subtract += System.currentTimeMillis() - notCount;
				view.clear();
			}
			System.out.println ("Mehrere Dokumente ber db.FTSearch laden:\t\t" + (System.currentTimeMillis()-L-subtract) + "ms / Treffer = " + (size/SEARCH_COUNT));
			System.out.println ("\tQuery hierbei: " + query);
			size=0;
			L=System.currentTimeMillis();
			subtract = 0;
			for (int i=SEARCH_COUNT; i > 0; i--) {				
				index = DemoTools.RANDOM_INDEX?DemoTools.getRandom(SEARCH_WIDTH):""+i;
				String word = DemoTools.ANIMAL_A + index;
				if (!exactSearch) {
					query="@left (F_titel;" + word.length() + ")=\"" + word + "\"";
				} else {
					query = "F_titel=\"" + word + "\"";
				}
				dc=db.search (query);
//				System.out.println(query);
				long notCount = System.currentTimeMillis();
				size+=dc.getCount();
				dc = GC.recycle(dc);
				subtract += System.currentTimeMillis() - notCount;
			}
			System.out.println ("Mehrere Dokumente ber db.search laden:\t\t\t" + (System.currentTimeMillis()-L-subtract) + "ms / Treffer = " + (size/SEARCH_COUNT));
			System.out.println ("\tQuery hierbei: " + query);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println ("id = " + (e instanceof NotesException?""+((NotesException)e).id:""));
		} finally {
			GC.recycle (doc);
			GC.recycle(dc);
			GC.recycle(vec);
			GC.recycle (view);
			GC.recycle (db);
			GC.recycle (session);
		}
		
	}

	/**
	 * @param session
	 * @return
	 */
	private int getMaxResult(Session session) {
		try {
			String s= session.getEnvironmentString("FT_MAX_SEARCH_RESULTS",true);
			return Integer.parseInt(s);
		} catch (Exception e) {
			return 5000;
		}
	}

	private static final int SEARCH_COUNT = 9;			// Anzahl der Suchoperationen UND
														// Teil des Suchwortes (bei
														// SEARCH_COUNT==9 wird nach
														// XXX0...XXX9 gesucht
	private static final boolean exactSearch = false; 	// Soll eine exakte Suche durchgefhrt werden?
														// Eine nicht exakte Suche liefert mehr Treffer
														// und ist aufwndiger.
	private static final boolean doStartup = true;		// Dokumente neu erzeugen??
	private static final int NUM_OF_DOCS = 10000;		// Anzahl dieser Dokumente
														// Falls NUM_OF_DOCS > 10000, so muss
														// in der notes.ini des Servers die Variable
														// FT_MAX_SEARCH_RESULTS mindestens auf den 
														// Wert NUM_OF_DOCS/10 gesetzt werden,
														// sonst werden die Ergebnissmengen limitiert.
	private static final int SEARCH_WIDTH = 1;			// Spezialisierung des Suchwortes (nur fr RANDOM)
														// SEARCH_WIDTH == 1 sucht nach XXX0..XXX9
														// SEARCH_WIDTH == 3 sucht nach XXX001...XXX999

}
